#ifndef ALD_MODEL_LEVEL_CONFIGURATION_H
#define ALD_MODEL_LEVEL_CONFIGURATION_H

#include <stdlib.h>
#include <stdbool.h>

#include "ald_types.h"

typedef struct feature_t feature_t;

typedef struct level_configuration_t level_configuration_t;

typedef struct level_list_item_t level_list_item_t;

//------------------------------------------- init / deinit -----------------------------------------------------
error_code_t level_configuration_init(const char *root_dir);

void level_configuration_deinit(void);

//------------------------------------------- level list -----------------------------------------------------
level_list_item_t *level_configuration_get_list_item(security_level_t level);

level_list_item_t *level_configuration_get_next_list_item(level_list_item_t *level_list_item);

security_level_t level_configuration_list_item_get_level(level_list_item_t *level_list_item);

bool level_configuration_list_item_has_level_pubkey(level_list_item_t *level_list_item);

//--------------------------------------------------------------------------------------------------------------

//------------------------------------------- loading and deleting -------------------------------------------
error_code_t level_configuration_load_level(level_configuration_t **level_conf_ptr, const char *root_dir,
		security_level_t level_number);

void level_configuration_free(level_configuration_t *level_conf);
//--------------------------------------------------------------------------------------------------------------

//------------------------------------------- level entry iterator ---------------------------------------------
const feature_t *level_configuration_get_first_feature(const level_configuration_t *level_conf);

feature_t *level_configuration_next_feature(const feature_t *feature);
//--------------------------------------------------------------------------------------------------------------

//------------------------------------------- attribute getters ------------------------------------------------
const char *level_configuration_feature_name(const feature_t *feature);

bool level_configuration_is_feature_active(const feature_t *feature);

security_level_t level_configuration_get_security_level(const level_configuration_t *level_conf);

void level_configuration_get_key_path_of_level(char *key_path,size_t path_max,const char *root_dir,
		security_level_t level);

bool level_configuration_check_pubkey(const char *level_scripts_path, security_level_t level);

bool level_configuration_is_permanent_level(const level_configuration_t *level_conf);

//--------------------------------------------------------------------------------------------------------------

//------------------------------------------- feature script path generation -----------------------------------
void level_configuration_get_prepare_script_path(char *path, size_t max_path_len,
		const level_configuration_t *level_conf, change_type_t type, const char *root_dir);

void level_configuration_get_finalize_script_path(char *path, size_t max_path_len,
		const level_configuration_t *level_conf, change_type_t type, const char *root_dir);

void level_configuration_get_volatile_feature_script_path(char *path, size_t max_path_len,
		const feature_t *feature, const char *root_dir);

void level_configuration_get_permanent_feature_script_path(char *path, size_t max_path_len,
		const feature_t *feature, const char *root_dir, bool is_permanent_level);
//--------------------------------------------------------------------------------------------------------------

#endif
